define([
    'underscore',
    'backbone',
    'marionette',
    'text!modules/notifications/notifications-button.html',
],
function (_, Backbone, Marionette, template) {
    'use strict';

    return Backbone.Marionette.View.extend({
        className: 'notifications',
        template: _.template(template),
        events: {'click #notifications-button': 'routeToNotificationsPage'},
        routeToNotificationsPage: function() {
            Backbone.history.navigate('notifications', {trigger: true});
        },
        templateContext: function() {
            var maxUnread = 99;
            return {
                hasUnread: this.collection.totalUnread() > 0,
                formattedTotalUnread: (this.collection.totalUnread() > maxUnread) ?
                    maxUnread + '+' :
                    (String(this.collection.totalUnread())),
            };
        },
    });
});
